<?php
require_once( 'utility.php' ) ;

function poweroff_vm( $esxi_ip, $esxi_username, $esxi_password, $vmpath_vix ) {
    debug_print( "power-off vm: $vmpath_vix ..." ) ;
    stop_vm_and_wait(
        $esxi_ip,
        $esxi_username,
        $esxi_password,
        $vmpath_vix ) ;
}

function register_vm( $esxi_ip, $esxi_username, $esxi_password, $vmpath_vix ) {
    global $BACKEND ;
    debug_print( "register vm: $vmpath_vix ..." ) ;
    exec_command( array( "$BACKEND register_esxi_vm",
        $esxi_ip,
        $esxi_username,
        $esxi_password,
        $vmpath_vix ) ) ;
}

function unregister_vm( $esxi_ip, $esxi_username, $esxi_password, $vmpath_vix ) {
    global $BACKEND ;
    debug_print( "unregister vm: $vmpath_vix ..." ) ;
    exec_command( array( "$BACKEND unregister_esxi_vm",
        $esxi_ip,
        $esxi_username,
        $esxi_password,
        $vmpath_vix ) ) ;
}

function delete_vm( $esxi_ip, $esxi_username, $esxi_password, $vmpath_vix ) {
    debug_print( "delete vm: $vmpath_vix ..." ) ;
    $ssh_cmd_path         = dirname(__FILE__) . "/ssh_cmd.sh" ;
    $folder_to_be_removed = dirname( $vmpath_vix ) ;
    exec_command( array( "$ssh_cmd_path",
        $esxi_ip,
        $esxi_username,
        $esxi_password,
        "\"rm -rf $folder_to_be_removed\"" ) ) ;
}

function remove_sb( $esxi_ip, $esxi_username, $esxi_password, $vmpath_vix ) {
    debug_print( "remove sandbox: $vmpath_vix ..." ) ;
    
    poweroff_vm( $esxi_ip, $esxi_username, $esxi_password, $vmpath_vix ) ;
    unregister_vm( $esxi_ip, $esxi_username, $esxi_password, $vmpath_vix ) ;
    delete_vm( $esxi_ip, $esxi_username, $esxi_password, $vmpath_vix ) ;
    
    $ip_usage_path = dirname(__FILE__) . "/../IPUsage" ;
    debug_print( "delete $vmpath_vix from $ip_usage_path ..." ) ;
    exec_command( array(
        "sed -i `grep -n $vmpath_vix $ip_usage_path | cut -d: -f1`d $ip_usage_path" ) ) ;
}

function clone_sandboxes( $argv ) {
	global $DTASCFG_XML_FILE, $BACKEND ;

	$xml = simplexml_load_file( $DTASCFG_XML_FILE) ;

	$esxi_ip       = chop( $xml->esxi->ip ) ;
	$esxi_username = chop( $xml->esxi->username ) ;
	$esxi_password =       $xml->esxi->password ;
    $sc_vmpath     = chop( $xml->sandbox_controller->image_path ) ;
    $ds_dir        = dirname( dirname( $sc_vmpath ) ) ;

	$sb_number     = chop( $xml->sandbox->number ) ;
	$scas_isopath  = "$ds_dir/sandcastle.iso" ;

    ########################################
    # ToBeRemoved
    ########################################
    $ori_active_img_count = 0 ;
    $lines = file( $GLOBALS[ "ORIGIN_SB_GROUP_INFO_ESXI_FILE" ] ) ;
    foreach( $lines as $line ) {
        if( trim( $line ) == "" ) continue ;
        $ori_active_img_count++ ;
    }
    debug_print( "ori_active_img_count: $ori_active_img_count" ) ;
    
    # for testing
    // $ori_active_img_count = 0 ;
    // print "  \$ori_active_img_count = $ori_active_img_count\n" ;
    
    if( $ori_active_img_count != 0 ) {
        $expect_removes = $sb_number / $ori_active_img_count ;
        
        # for testing
        #$expect_removes = 1 ;

        debug_print( "sb_number: $sb_number" ) ;
        debug_print( "ori_active_img_count: $ori_active_img_count" ) ;
        debug_print( "expect_removes: $expect_removes" ) ;
		
        $lines = file( $GLOBALS[ "NEW_SB_GROUP_TO_BE_REMOVED_FILE" ] ) ;
        foreach( $lines as $sb_vmpath ) {
            $sb_vmpath = trim( $sb_vmpath ) ;
            if( $sb_vmpath == "" ) continue ;
            
            $sb_original_name = basename( $sb_vmpath, ".vmx" ) . "_" ;
            
            for( $i = $expect_removes ; $i > 0 ; $i-- ) {
                $vmpath_to_be_removed = "$ds_dir/${sb_original_name}$i/${sb_original_name}${i}.vmx" ;
				debug_print( "vmpath_to_be_removed: $vmpath_to_be_removed" ) ;
                remove_sb(
                    $esxi_ip,
                    $esxi_username,
                    $esxi_password,
                    $vmpath_to_be_removed ) ;
            }
            debug_print( "sb_vmpath: $sb_vmpath" ) ;
            # remove original sandbox (with sanstle installed) (it should be already unregistered)
            delete_vm(
                $esxi_ip,
                $esxi_username,
                $esxi_password,
                $sb_vmpath ) ;
				
			# change pure vm dir, /vmfs/volumes/${uuid}/DDA_WIN7_IMAGE1_ORIGIN/ -> /vmfs/volumes/${uuid}/DDA_WIN7_IMAGE1/
			debug_print( "copy \"change_pure_vm_dir.sh\" to datastore: $ds_dir ...\n" );
			copy_file_to_esxi( array(
				'from' => dirname(__FILE__) . "/../change_pure_vm_dir.sh",
				'to'   => "$ds_dir"
			) ) ;
			
			$sb_postfix = "ORIGIN" ;
			debug_print( "change pure vm path (ex: DDA_1_ORIGIN to DDA_1): ${sb_vmpath}; ${sb_postfix}" ) ;
			run_command_at_esxi( array(
				'command' => "$ds_dir/change_pure_vm_dir.sh $sb_vmpath $sb_postfix"
			) ) ;
			
			# register origin sb vm
			register_vm(
                $esxi_ip,
                $esxi_username,
                $esxi_password,
                $sb_vmpath ) ;
                
            # change isActive
        }
    }

    ########################################
    # ToBeKept (Adjust number of sandbox)
    ########################################
	debug_print( "copy \"clonevm.sh\" to datastore: $ds_dir ..." ) ;
	copy_file_to_esxi( array(
        'from' => dirname(__FILE__) . "/../clonevm.sh",
        'to'   => "$ds_dir"
    ) ) ; 

    $exp_active_img_count = 0 ;
    $lines = file( $GLOBALS[ "NEW_SB_GROUP_INFO_ESXI_FILE" ] ) ;
    foreach( $lines as $sb_vmpath ) {
        if( trim( $sb_vmpath ) == "" ) continue ;
        $exp_active_img_count++ ;
    }
    
    $sb_num_origin = ( $ori_active_img_count == 0 ) ? 0 : $sb_number / $ori_active_img_count ;
    $sb_num_expect = ( $exp_active_img_count == 0 ) ? 0 : $sb_number / $exp_active_img_count ;

    # for testing
    // $sb_num_origin = 3 ;
    // $sb_num_expect = 4 ;
    
    
    $sb_added_path = $GLOBALS[ "NEW_SB_ADDED_FILE" ] ;
    if( file_exists( $sb_added_path ) ) {
        unlink( $sb_added_path ) ;
    }

    # increase sandbox number (clone sandbox)
    if( $sb_num_expect > $sb_num_origin ) {
    
        $lines = file( $GLOBALS[ "NEW_SB_GROUP_TO_BE_KEPT_FILE" ] ) ;
        foreach( $lines as $sb_vmpath ) {
            $sb_vmpath = trim( $sb_vmpath ) ;
            if( $sb_vmpath == "" ) continue ;
            
            $sb_original_name = basename( $sb_vmpath, ".vmx" ) . "_" ;

            register_vm(
                $esxi_ip,
                $esxi_username,
                $esxi_password,
                $sb_vmpath ) ;

            $start = $sb_num_origin + 1 ;
            $end   = $sb_num_expect ;
			
            debug_print( "clone sandbox: $start ~ $end" ) ;
		    run_command_at_esxi( array(
				'command' => "$ds_dir/clonevm.sh $sb_vmpath $sb_original_name $start $end"
			) ) ;
            
			# echo added sandboxes path to $NEW_SB_ADDED_FILE
            for( $j = $start; $j <= $end ; $j++ ) {
                $tmp = "${ds_dir}/${sb_original_name}${j}/${sb_original_name}${j}.vmx" ;
                debug_print( "Update new sandbox: $tmp to $sb_added_path" ) ;
                exec_command( array( "echo $tmp >> $sb_added_path" ) ) ;
            }
            
            unregister_vm(
                $esxi_ip,
                $esxi_username,
                $esxi_password,
                $sb_vmpath ) ;

            # insert sandbox.iso into CD-ROM
            for( $i = $start ; $i <= $end ; $i++ ) {
                debug_print( "insert \"sandbox.iso\" to sandbox_$i ..." ) ;
                
				$cloned_sb_vmpath = "$ds_dir/$sb_original_name$i/$sb_original_name$i.vmx" ;
				run_command_at_esxi( array(
					'command' => "sed -i '/ide1:0.fileName = .*/d' $cloned_sb_vmpath"
				) ) ;
				
				run_command_at_esxi( array(
					'command' => "echo 'ide1:0.fileName = \\\"$scas_isopath\\\"' >> $cloned_sb_vmpath"
				) ) ;
            }
        }
    }
    
    # decrease sandbox number (remove cloned sandbox)
    elseif( $sb_num_expect < $sb_num_origin ) {
    
        $lines = file( $GLOBALS[ "NEW_SB_GROUP_TO_BE_KEPT_FILE" ] ) ;
        foreach( $lines as $sb_vmpath ) {
            $sb_vmpath = trim( $sb_vmpath ) ;
			if( $sb_vmpath == "" ) continue ;
            
            $sb_original_name = basename( $sb_vmpath, ".vmx" ) . "_" ;
            
            for( $i = $sb_num_origin ; $i > $sb_num_expect ; $i-- ) {
                $sb_to_be_removed = "$ds_dir/${sb_original_name}$i/${sb_original_name}${i}.vmx" ;
                remove_sb(
                    $esxi_ip,
                    $esxi_username,
                    $esxi_password,
                    $sb_to_be_removed ) ;
            }
        }
    }
 
    ########################################
    # ToBeAdded
    ########################################
    $active_img_count = 0 ;
    $lines = file( $GLOBALS[ "NEW_SB_GROUP_TO_BE_ADDED_FILE" ] ) ;
    foreach( $lines as $sb_vmpath ) {
		if( trim( $sb_vmpath ) == "" ) continue ;
        $active_img_count++ ;
    }

    $lines = file( $GLOBALS[ "NEW_SB_GROUP_TO_BE_KEPT_FILE" ] ) ;
	foreach( $lines as $sb_vmpath ) {
		if( trim( $sb_vmpath ) == "" ) continue ;
        $active_img_count++ ;
    }

    $expect_copies = $sb_number / $active_img_count ;
	
	// for testing
    // $expect_copies = 1 ;
   
    $lines = file( $GLOBALS[ "NEW_SB_GROUP_TO_BE_ADDED_FILE" ] ) ;
    foreach( $lines as $sb_vmpath ) {
        $sb_vmpath = trim( $sb_vmpath ) ;
		if ( $sb_vmpath == "" ) continue ;
		
        $sb_original_name = basename( $sb_vmpath, ".vmx" ) . "_" ;

        /* try to stop sandbox */
        debug_print( "power-off sandbox: $sb_vmpath ..." ) ;
        stop_vm_and_wait( $esxi_ip, $esxi_username, $esxi_password, $sb_vmpath ) ;

        debug_print( "remove sandbox's all snapshots: $sb_vmpath ..." ) ;
        remove_all_vm_snapshots( $esxi_ip, $esxi_username, $esxi_password, $sb_vmpath ) ;
        
        debug_print( "clone $expect_copies copies of sandbox ..." ) ;
		run_command_at_esxi( array(
			'command' => "$ds_dir/clonevm.sh $sb_vmpath $sb_original_name 1 $expect_copies"
		) ) ;

        for( $i = 1 ; $i <= $expect_copies ; $i++ ) {
            debug_print( "insert \"sandbox.iso\" to sb_$i ..." ) ;
            
            $tmp = "$ds_dir/$sb_original_name$i/$sb_original_name$i.vmx" ;
			run_command_at_esxi( array(
				'command' => "sed -i '/ide1:0.fileName = .*/d' $tmp"
			) ) ;
			run_command_at_esxi( array(
				'command' => "echo 'ide1:0.fileName = \\\"$scas_isopath\\\"' >> $tmp"
			) ) ;
                
            debug_print( "Update new sandbox: $tmp to $sb_added_path" ) ;
            exec_command( array( "echo $tmp >> $sb_added_path" ) ) ;
        }
	
        debug_print( "unregister original sandbox: $sb_vmpath ..." ) ;
        unregister_vm(
            $esxi_ip,
            $esxi_username,
            $esxi_password,
            $sb_vmpath ) ;
    }
}